/*
 * Decompiled with CFR 0.152.
 */
package mod.traister101.sns.network;

import mod.traister101.sns.common.items.ContainerItem;
import mod.traister101.sns.util.NBTHelper;
import mod.traister101.sns.util.SNSUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public final class ServerboundTogglePacket {
    private final boolean toggle;
    private final SNSUtils.ToggleType type;

    public ServerboundTogglePacket(boolean toggle, SNSUtils.ToggleType type) {
        this.toggle = toggle;
        this.type = type;
    }

    ServerboundTogglePacket(FriendlyByteBuf friendlyByteBuf) {
        this.toggle = friendlyByteBuf.readBoolean();
        this.type = SNSUtils.ToggleType.byId(friendlyByteBuf.readInt());
    }

    void encode(FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.writeBoolean(this.toggle);
        friendlyByteBuf.writeInt(this.type.ordinal());
    }

    void handle(@Nullable ServerPlayer player) {
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.m_21205_();
        Item item = mainHandItem.m_41720_();
        if (!(item instanceof ContainerItem)) {
            return;
        }
        ContainerItem containerItem = (ContainerItem)item;
        if (!this.type.supportsContainerType(containerItem.type)) {
            return;
        }
        NBTHelper.toggle(mainHandItem, this.type, this.toggle);
    }
}

